varying vec2 		texcoord;
varying vec2		alphacoords;
uniform sampler2D 	tex;
uniform sampler2D 	lmask;
uniform vec4		diffuseColor;
uniform vec2		spec;
varying float		fadeAlpha;

float blend1D(float f1, float f2, float a1, float a2, float alpha)
{
	float depth=0.2;
	float ma=max(a1+(1.0-alpha),a2+alpha)-depth;
	
	float b1=max(a1 + (1.0-alpha) - ma,0.0);
	float b2=max(a2 + alpha - ma,0.0);
	
	return (f1*b1 + f2*b2)/(b1+b2);
}

void main()
{
	vec3 color=pow(texture2D(tex,texcoord.st).xyz,vec3(2.2));
	float colorAlpha=texture2D(lmask,alphacoords.st).w;

	float alpha=clamp(colorAlpha*fadeAlpha,0.0,1.0);
	alpha=blend1D(0.0, 1.0, 0.8, colorAlpha, alpha);
	
	gl_FragData[0].rgb=color*diffuseColor.xyz*alpha;
	gl_FragData[0].a=alpha;
	
	gl_FragData[1].r=0.0;
	gl_FragData[1].g=spec.y*alpha;
	gl_FragData[1].b=0.0;
	gl_FragData[1].a=alpha;
}
